/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.recipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.logging.LogUtils;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.NonNullList;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import plus.dragons.createcentralkitchen.foundation.data.tag.IntegrationItemTags;

@Mod.EventBusSubscriber(modid="create_central_kitchen")
public class IgnoreAutomaticShapelessRecipe {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Cache<Recipe<?>, Boolean> CACHED_IGNORED_RECIPES = CacheBuilder.newBuilder().build();
    public static final ResourceManagerReloadListener LISTENER = resourceManager -> {
        long size = CACHED_IGNORED_RECIPES.size();
        CACHED_IGNORED_RECIPES.invalidateAll();
        LOGGER.debug("Invalidated IgnoreAutoShapelessRecipe's cache of size: {}", (Object)size);
    };

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)LISTENER);
    }

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        long size = CACHED_IGNORED_RECIPES.size();
        CACHED_IGNORED_RECIPES.invalidateAll();
        LOGGER.debug("Invalidated IgnoreAutoShapelessRecipe's cache of size: {}", (Object)size);
    }

    public static boolean get(Recipe<?> recipe) {
        try {
            return (Boolean)CACHED_IGNORED_RECIPES.get(recipe, () -> IgnoreAutomaticShapelessRecipe.shouldIgnoreShapelessRecipe(recipe));
        }
        catch (ExecutionException exception) {
            LOGGER.warn("Exception while computing if recipe {} should be ignored in automation", (Object)recipe.m_6423_(), (Object)exception);
            return false;
        }
    }

    private static boolean shouldIgnoreShapelessRecipe(Recipe<?> recipe) {
        if (IgnoreAutomaticShapelessRecipe.shouldIgnoreItemInAutomation(recipe.m_8043_())) {
            return true;
        }
        NonNullList ingredients = recipe.m_7527_();
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return false;
        }
        if (ingredientSize == 1) {
            return IgnoreAutomaticShapelessRecipe.shouldIgnoreIngredientInAutomation((Ingredient)ingredients.get(0));
        }
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (!IgnoreAutomaticShapelessRecipe.shouldIgnoreIngredientInAutomation(ingredient)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldIgnoreIngredientInAutomation(Ingredient ingredient) {
        ItemStack[] items = ingredient.m_43908_();
        if (items.length == 0) {
            return false;
        }
        if (items.length == 1) {
            return IgnoreAutomaticShapelessRecipe.shouldIgnoreItemInAutomation(items[0]);
        }
        for (ItemStack stack : items) {
            if (IgnoreAutomaticShapelessRecipe.shouldIgnoreItemInAutomation(items[0])) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldIgnoreItemInAutomation(ItemStack item) {
        return item.m_204117_(IntegrationItemTags.IGNORED_IN_AUTOMATIC_SHAPELESS.tag) || item.hasContainerItem() && item.getContainerItem().m_204117_(IntegrationItemTags.IGNORED_IN_AUTOMATIC_SHAPELESS.tag);
    }
}

